module net.BurtonRadons.spyl.expressionIndex;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.expressionBinary;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** Index an array; "a [b]". */
class IndexExpression : BinaryExpression
{
    /** Assign the parameters. */
    this (Mark mark, Expression a, Expression b)
    {
        super (mark, a, b);
    }
    
    override Value evaluate (Scope scope)
    {
        return a.evaluate (scope).getitem (b.evaluate (scope));
    }
    
    override char [] toString ()
    {
        return subString (a) ~ " [" ~ b.toString (Precedence.Unary) ~ "]";
    }
    
    override int precedence ()
    {
        return Precedence.Postfix;
    }
}